function bin = dectobin(dec, width, signed)
%bin = dectobin(dec, width, signed)

%Copyright (C) 2008 Anton Blad, Oscar Gustafsson.
%This file is licensed under a modified version of GPL v2, see the file
%LICENSE for details.

if size(dec, 2) > 1
	error "dectobin : column vector required"
end

N = length(dec);
bin = zeros(N, width);

if signed == 0
	if any(dec < 0) | any(dec >= 2^width)
		disp(sprintf('Warning: dectobin: argument overflow'));
	end

	for n = width-1:-1:0
		v = dec >= 2^n;
		bin(:, width-n) = v;
		dec = dec - 2^n*v;
	end
elseif signed == 1
	if any(dec < -2^(width-1)) | any(dec >= 2^(width-1))
		disp(sprintf('Warning: dectobin: argument overflow'));
	end

	v = dec < 0;
	dec = dec + 2^width*v;

	for n = width-1:-1:0
		v = dec >= 2^n;
		bin(:, width-n) = v;
		dec = dec - 2^n*v;
	end
else
	error "dectobin : signed argument invalid"
end

